﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService.Mappers
{
    public class MapNpiToCrm : MapperRelatedBase
    {
        public MapNpiToCrm(IPpmsContextHelper ppmsContextHelper, IPpmsHelper ppmsHelper)
            : base(ppmsContextHelper, ppmsHelper)
        {}

        public async Task<ppms_provideridentifier> MapInsert(Npi schemaNpi, Account provider)
        {
            var npi = new ppms_provideridentifier
            {
                Id = Guid.NewGuid(),
                ppms_ProviderIdentifier = schemaNpi.Number,
                ppms_IdentifierType = new OptionSetValue((int)ppms_ProviderIdentifierType.NPI),
                ppms_NPIType = ResolveNpiType(schemaNpi.EntityTypeCode)
            };

            // Set owner to CCN
            if (!ForVaNetwork && Owner != null) npi.OwnerId = Owner;

            await Task.Run(() => {});

            return npi;
        }

        public async Task<ppms_provideridentifier> MapUpdate(Npi npi, Account provider)
        {
            // check if entity exists
            var crmEntity = GetCrmEntity(provider, npi.Number);
            if (crmEntity == null)
            {
                return await MapInsert(npi, provider);
            }

            //var entity = new ppms_provideridentifier()
            //{
            //    Id = crmEntity.Id,
            //    ppms_IdentifierType = crmEntity.ppms_IdentifierType
            //};

            //// name
            //if (IsChanged(npi.Number, crmEntity.ppms_ProviderIdentifier))
            //{
            //    entity.ppms_ProviderIdentifier = npi.Number;
            //}

            //// Set owner to CCN
            //if (!ForVaNetwork && Owner != null) entity.OwnerId = Owner;

            // Updates not allowed on NPIs
            return null;
        }

        private static ppms_provideridentifier GetCrmEntity(Account provider, string id)
        {
            var list = provider.ppms_account_ppms_provideridentifier_Provider;
            if (list == null) return null;

            var ppmsProvideridentifiers = list as ppms_provideridentifier[] ?? list.ToArray();

            return ppmsProvideridentifiers.Any() ? ppmsProvideridentifiers.FirstOrDefault(x => x.ppms_ProviderIdentifier == id) : null;
        }

        private static OptionSetValue ResolveNpiType(NpiType npiType)
        {
            var npiTypeValue = npiType == NpiType.Item1Individual
                ? (int)ppms_provideridentifier_ppms_NPIType._1Individual
                : (int)ppms_provideridentifier_ppms_NPIType._2Organizational;

            return new OptionSetValue(npiTypeValue);
        }

        private static Npi ConvertEntity<T>(T entity)
        {
            return (Npi)Convert.ChangeType(entity, typeof(Npi));
        }

        public override async Task<Entity> MapUpdate<T>(T entity, Entity parent)
        {
            return await MapUpdate(ConvertEntity(entity), (Account)parent);
        }

        public override async Task<Entity> MapInsert<T>(T entity, Entity parent)
        {
            return await MapInsert(ConvertEntity(entity), (Account)parent);
        }

        public override void AddChildrenToProvider(IList<Entity> entities, Entity parent)
        {
            if (IsWithinContext) AssociateRelatedEntities(parent, entities, "ppms_account_ppms_provideridentifier_Provider");
            else
            {
                if (entities != null && entities.Count > 0)
                {
                    var account = (Account)parent;
                    if (account != null) account.ppms_account_ppms_provideridentifier_Provider = ConvertEntityList<ppms_provideridentifier>(entities);
                }
            }
        }

        public override IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent)
        {
            if (entities == null || !entities.Any()) return null;

            // Check provider
            var provider = (Account)parent;
            if (provider == null) return null;

            var list = new List<ppms_provideridentifier>();
            var relatedEntities = provider.ppms_account_ppms_provideridentifier_Provider.ToList();
            Npi entity;

            if (relatedEntities != null && relatedEntities.Any())
            {
                // Map schema entities for delete
                foreach (var item in entities)
                {
                    entity = ConvertEntity(item);
                    var matches = relatedEntities.Where(p => p.ppms_ProviderIdentifier == entity.Number);
                    list.AddRange(matches);
                }
            }

            return EntityDelete((IEnumerable<ppms_provideridentifier>)list);
        }
    }
}